﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.EFR;

public partial class controls_DoDFragmentDetail : System.Web.UI.UserControl
{
    DoDFragmentManager _manager = new DoDFragmentManager();

    protected void Page_Load(object sender, EventArgs e)
    {
        LoadBaseControls();
    }

    private void Page_PreRender(object sender, EventArgs e)
    {
        LoadControlsFromObject();
    }

    public string FragmentID
    {
        set
        {
            HiddenFieldFragmentID.Value = value;
        }
    }

    public string PatientID
    {
        set
        {
            HiddenFieldPatientID.Value = value;
        }
    }

    private void LoadControlsFromObject()
    {
        DOD_FRAGMENT fragment = _manager.GetDoDFragmentById(Helpers.getIntFromString(HiddenFieldFragmentID.Value));

        if (fragment != null)
        {
            BaseControlLabelFragmentID.Text = fragment.FRAGMENT_ID_NUMBER;
            BaseControlLabelFragmentDesc.Text = fragment.FRAGMENT_DESCRIPTION;
            BaseControlLabelFragmentMass.Text = fragment.MASS;
            BaseControlLabelFragmentMassUOM.Text = fragment.MASS_UNITS;
            BaseControlLabelFragmentLength.Text = fragment.LENGTH;
            BaseControlLabelFragmentLengthUOM.Text = fragment.LENGTH_UNITS;
            BaseControlLabelFragmentHeight.Text = fragment.HEIGHT;
            BaseControlLabelFragmentHeightUOM.Text = fragment.HEIGHT_UNITS;
            BaseControlLabelFragmentWidth.Text = fragment.WIDTH;
            BaseControlLabelFragmentWidthUOM.Text = fragment.WIDTH_UNITS;
            BaseControlLabelFragmentRadioActiveInd.Text = fragment.RADIOACTIVEINDICATOR;
            BaseControlLabelFragmentRadioActiveResults.Text = fragment.RADIOACTIVERESULTS;
            BaseControlLabelFragmentComments.Text = fragment.COMMENTS;
            if (fragment.TISSUE_SENT_FLAG.HasValue)
            {
                BaseControlLabelFragmentTissueIndicator.Text = fragment.TISSUE_SENT_FLAG == true ? "Yes" : "No";
            }
            BaseControlLabelFragmentTissueAssociated.Text = fragment.TISSUE_ASSOCIATED_WITH_FRAGMENT;

            HiddenFieldLabID.Value = fragment.DOD_FRAGMENT_LAB_ID.ToString();
        }
    }

    private void LoadBaseControls()
    {
        RegistriesCommonManager commonManager = new RegistriesCommonManager();
        List<STD_GUI_CONTROL> controls = commonManager.GetStdGuiControlsByCategory("DOD_FRAGMENT_DETAIL_CONTROL", EFRSharedConstant.EfrRegistryId);

        foreach (STD_GUI_CONTROL dbItem in controls)
        {
            Control userControl = null;

            userControl = PanelFragmentDetails.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl == null)
            {
                userControl = PanelDimension.FindControl(dbItem.USER_CONTROL_ID);
            }
            if (userControl != null)
            {
                controls_BaseControlLabel baseControl = (controls_BaseControlLabel)userControl;
                baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT,
                    dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL);
            }
        }
    }


}
